/**
 * Sample Applet application showing dynamic tesselation of heightmap using ROAM
 * <p>
 *  First & old work on the 3DzzD landscape engine
 * </p>
 * @author: bruno augier
 * @website: http://dzzd.net/ 
 * @version: 1.00 05/06/28
 */
 
import java.awt.*;
import java.applet.*;
import java.util.Hashtable;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseEvent;
import java.awt.image.MemoryImageSource;
import java.awt.image.DirectColorModel;

public class Animator extends Applet implements Runnable,MouseListener,MouseMotionListener,IReadWrite3D
{
	//Backbuffer
	private Image i;
	private Graphics ig;
	
	//Mouse pos
	private double x,y,z;

	//Background image
	private MemoryImageSource mis;
	private int misPixels[];
	private Image misImage;
	
	//Landscape tesselator
	private Landscape3D land;
	
	public void init() 
	{
		//Build a background image
		int w=256;
		int h=256;
		DirectColorModel misColorModel=new DirectColorModel(32,0xFF0000,0xFF00,0xFF,0xFF000000);
		this.misPixels=new int[w*h];
		this.mis = new MemoryImageSource(w,h,misColorModel, misPixels,0, w);
	    this.mis.setAnimated(true);
	    this.mis.setFullBufferUpdates(true);
	    this.misImage = createImage(mis);
	    
	    //Build an heightmap and set background image pixels
	    byte hMap[]=new byte[w*h];
	    for (int x=0;x<w;x++)
	    	for (int y=0;y<h;y++)
	    	{
	    		double xr=x-(w/2);
	    		double yr=y-(h/2);
	    		xr/=(w/2);
	    		yr/=(h/2);
	    		double dist=Math.sqrt(xr*xr+yr*yr);
	    		xr/=dist;
	    		yr/=dist;
	    		int angle=(int)(180.0*Math.acos(xr)/Math.PI);	    		
	    		{
	    			int a=0x0;
	    			int r=0x0;
		    		int g=0x0;
		    		int b=0x0;

		    		double light=0;
	    			light=1.0/(1+dist*5);
	    			if(light<0.0) light=0.0;
	    			r+=((int)(128.0*light))&0xFF;
	    			g+=((int)(64.0*light))&0xFF;
	    			b+=((int)(0.0*light))&0xFF;
	    			
		    		light=1.0/(1+dist*10);
		    		if(light<0.0) light=0.0;
		    		r+=((int)(255.0*light))&0xFF;
		    		g+=((int)(255.0*light))&0xFF;
		    		b+=((int)(255.0*light))&0xFF;
		    		
		    		if(angle%45==0)
		    		{
		    			//light=1-(dist/2);
		    			light=1.0/(1+dist*5);
		    			if(light<0.0) light=0.0;
		    			r+=((int)(64.0*light))&0xFF;
		    			g+=((int)(64.0*light))&0xFF;
		    			b+=((int)(64.0*light))&0xFF;
		    		}
			    	
			    		
		    		light=1.0/(1+dist*5);
		    		a=(int)(light*255);
		    		if(a>0xFF) a=0xFF;
		    		if(r>0xFF) r=0xFF;
		    		if(g>0xFF) g=0xFF;
		    		if(b>0xFF) b=0xFF;
		    		
		    			hMap[x+y*w]=(byte)Math.abs((127*Math.cos(Math.PI*dist*1.5)));
	    			misPixels[x+y*w]=0xff<<24|hMap[x+y*w];
	    		}
	    	}
	    
	    //Build landscape	
		this.land=new Landscape3D();
		this.land.init(hMap,w,h,14,4);
		this.land.computeVariance();
		this.land.tessellate(w/2,h/2);
		
		//Create a backbuffer and start main rendering thread
		this.addMouseListener(this);
		this.addMouseMotionListener(this);
		this.setSize(256,256);
		this.i=this.createImage(this.getWidth(),this.getHeight());
		this.ig=i.getGraphics();
		this.ig.setFont(new Font("Arial",Font.PLAIN|Font.BOLD,12));
		Thread t=new Thread(this);
		t.start();
		
	}
	
	public void update(Graphics g)
	{
		//Draw Heightmap on background
		this.mis.newPixels();
		this.ig.drawImage(misImage,0,0,null);
		
		//Draw faces
		this.ig.setColor(Color.white);
		this.land.reset();
		this.land.tessellate(this.get3DX(), this.get3DY());
		this.land.render(this.ig);
		
		//Draw number of faces
		this.ig.setColor(Color.red);
		this.ig.drawString((int)(land.nbpol)+" faces", 10,20);
		
		//Draw final image to screen
		g.drawImage(this.i,0,0,null);
		
	}
	
	public void paint(Graphics g) 
	{   
	}
	
	public void run()
	{
		while(Thread.currentThread().isAlive())
		{
			this.update(this.getGraphics());
			Thread.yield();
		}	
	}
	
	public void mouseClicked(MouseEvent e) 
	{}
         
    public void mouseEntered(MouseEvent e) 
    {
    }
          
    public void mouseExited(MouseEvent e) 
    {}
        
    public void mousePressed(MouseEvent e) 
    {
    }
         
    public void mouseReleased(MouseEvent e) 
    {
    }
    
    public void mouseDragged(MouseEvent e)
    {}
          
 	public void mouseMoved(MouseEvent e)
 	{
 		this.y=e.getY();
 		this.x=e.getX();
 	}
 
	/**
	* @return the x value 
	*/	
	public double get3DX()
	{
		return this.x;
	}

	/**
	* @return the y value 
	*/	
	public double get3DY()
	{
		return this.y;
	}

	/**
	 * @return the z value 
	 */	
	public double get3DZ()
	{
		return this.z;
	}
	
	/**
	 * Set x value
	 *
	 * @param x x value 
	 */	
	public void set3DX(double x)
	{
		this.x=x;
	}

	/**
	 * Set y value
	 *
	 * @param y the y value 
	 */	
	public void set3DY(double y)
	{
		this.y=y;
	}

	/**
	 * Set z value
	 *
	 * @param z the z value 
	 */	
	public void set3DZ(double z)
	{
		this.z=z;
	}	


}
