import java.awt.*;

public class Landscape3D
{
	private byte hMap[];
	private int width;
	private int height;
	private int nextFaceNodeIndex;
	private FaceNode faceNodeBuffer[]; 
	private FaceNode leftRootNode; 
	private FaceNode rightRootNode;
	private byte lVariance[];
	private byte rVariance[];
	private byte cVariance[];
	private int varianceDepth;
	private double renderVariance;
	public int nbpol;
	
	Landscape3D()
	{
		this.leftRootNode=new FaceNode();
		this.rightRootNode=new FaceNode();
		
	}
	
	public class FaceNode
	{
	   	FaceNode leftChild; 
    	FaceNode rightChild; 
    	FaceNode base; 
    	FaceNode left; 
    	FaceNode right; 
	}
	
	public void init(byte hMap[],int width,int height,int varianceDepth,double renderVariance)
	{
		this.hMap=hMap;
		this.width=width;
		this.height=height;
		this.varianceDepth=varianceDepth;
		this.lVariance=new byte[1<<this.varianceDepth];
		this.rVariance=new byte[1<<this.varianceDepth];
		this.renderVariance=renderVariance;
		this.reset();
	}
	
	public void reset()
	{
		this.leftRootNode.left=null;	
		this.leftRootNode.right=null;
		this.leftRootNode.base=null;
		this.leftRootNode.leftChild=null;
		this.leftRootNode.rightChild=null;
		this.rightRootNode.left=null;	
		this.rightRootNode.right=null;
		this.rightRootNode.base=null;
		this.rightRootNode.leftChild=null;
		this.rightRootNode.rightChild=null;
		this.rightRootNode.base=this.leftRootNode;
		this.leftRootNode.base=this.rightRootNode;		
		nbpol=0;
		
	}
	
	public FaceNode newFaceNode()
	{
		return new FaceNode();
	}
	
	public double recursComputeVariance( int leftX,int leftY,byte leftZ,int rightX, int rightY,byte rightZ,int apexX,int apexY,byte apexZ,int node)
	{
		int centerX = (leftX + rightX) >>1;
		int centerY = (leftY + rightY) >>1;	
	    byte centerZ  = this.hMap[(centerY * this.width) + centerX];	
	    double variance=Math.abs((int)centerZ - (((int)leftZ + (int)rightZ)>>1));
		
		if ( (((int)Math.abs(leftX - rightX)) >= 4) || ((int)(Math.abs(leftY - rightY)) >= 4) )
		{
			variance=Math.max( variance, this.recursComputeVariance( apexX,   apexY,  apexZ, leftX, leftY, leftZ, centerX, centerY, centerZ,node<<1 ));
			variance=Math.max( variance, this.recursComputeVariance(  rightX, rightY, rightZ, apexX, apexY, apexZ, centerX, centerY, centerZ,1+(node<<1)) );
		}
		
		if (node < (1<<this.varianceDepth))
			cVariance[node] = (byte) (1+variance);
		
		return variance;
	}

	public void computeVariance()
	{
		int xMin=0;
		int yMin=0;		
		int xMax=this.width-1;
		int yMax=this.height-1;
	    this.cVariance=lVariance;
	    this.recursComputeVariance(xMin,yMax,hMap[yMax * this.width],xMax,yMin,hMap[xMax],xMin,yMin,hMap[0],1);	
	    this.cVariance=rVariance;
	    this.recursComputeVariance(xMax,yMin,hMap[xMax],xMin,yMax,hMap[yMax*this.width],xMax,yMax,hMap[xMax+yMax*this.width],1);		    
	}
	
	public void recursTessellate(FaceNode nodeRef,int leftX,int leftY,int rightX,int rightY,int apexX,int apexY,int node,double viewPosX,double viewPosY)
	{
		int centerX = (leftX + rightX) >>1;
		int centerY = (leftY + rightY) >>1;
	    double variance=0;	
		if ( node < (1<<this.varianceDepth) )
		{
			double distance = 2.0*Math.sqrt( (centerX - viewPosX)*(centerX - viewPosX) +  (centerY - viewPosY)*(centerY - viewPosY) );
			if(distance>this.width)
			 distance=this.width;
			variance = this.cVariance[node] *(1.0-((distance*distance)/(this.width*this.width)));	
		}	  
		
		if ( (node <(1<<4)) ||/*(node >=(1<<this.varianceDepth)) ||*/ (variance > this.renderVariance) )	
		{
			this.split(nodeRef);														
			if ( (nodeRef.leftChild != null) && ((Math.abs(leftX - rightX) >= 4) || (Math.abs(leftY - rightY) >= 4)))
			{
				this.recursTessellate( nodeRef.leftChild, apexX,  apexY, leftX, leftY, centerX, centerY,    node<<1  ,viewPosX,viewPosY);
				this.recursTessellate( nodeRef.rightChild, rightX, rightY, apexX, apexY, centerX, centerY, 1+(node<<1) ,viewPosX,viewPosY);
			}
		}	
			  
	}		
	
	public void tessellate(double viewPosX,double viewPosY)
	{
		int xMin=0;
		int yMin=0;
		int xMax=this.width-1;
		int yMax=this.height-1;
		
		this.cVariance = lVariance;
		this.recursTessellate(this.leftRootNode,xMin,yMax,xMax,yMin,xMin,yMin,1,viewPosX,viewPosY);					
		this.cVariance = rVariance;
		this.recursTessellate(this.rightRootNode,xMax,yMin,xMin,yMax,xMax,yMax,1,viewPosX,viewPosY);
	}
	
	public void split(FaceNode node)
	{
		
		if(node.leftChild != null)
			return;
			
		if((node.base != null) && (node.base.base != node))
			this.split(node.base);
			
		node.leftChild  = this.newFaceNode();
		node.rightChild = this.newFaceNode();

		if (node.leftChild == null)
			return;
			
		node.leftChild.base  = node.left;
		node.leftChild.left  = node.rightChild;

		node.rightChild.base  = node.right;
		node.rightChild.right = node.leftChild;

		if(node.left != null)
		{
			if (node.left.base == node)
				node.left.base = node.leftChild;
			else
			{
				if(node.left.left == node)
					node.left.left = node.leftChild;
				else 
					if(node.left.right == node)
						node.left.right = node.leftChild;
			}
		}
	
		
		if(node.right != null)
		{
			if (node.right.base == node)
				node.right.base = node.rightChild;
			else	
			{			
				if(node.right.right == node)
					node.right.right = node.rightChild;
				else
					if(node.right.left == node)
						node.right.left = node.rightChild;
			}
		}
	
		
		if(node.base != null)
		{
			if(node.base.leftChild != null)
			{
				node.base.leftChild.right = node.rightChild;
				node.base.rightChild.left = node.leftChild;
				node.leftChild.right = node.base.rightChild;
				node.rightChild.left = node.base.leftChild;
			}
			else
				this.split(node.base);  
		}
		else
		{
			node.leftChild.right = null;
			node.rightChild.left = null;
		}		
	
	
	}
	
	public void recursRender(FaceNode node, int leftX, int leftY, int rightX, int rightY, int apexX, int apexY,Graphics g)
	{
		if (node.leftChild != null)					
		{
			int centerX = (leftX + rightX)>>1;
			int centerY = (leftY + rightY)>>1;
			this.recursRender( node.leftChild,  apexX,   apexY, leftX, leftY, centerX, centerY,g);
			this.recursRender( node.rightChild, rightX, rightY, apexX, apexY, centerX, centerY,g);
		}
		else								
		{	
			g.drawLine(leftX,leftY,rightX,rightY);
			g.drawLine(rightX,rightY,apexX,apexY);
			g.drawLine(apexX,apexY,leftX,leftY);
			nbpol++;
		
		}
	}
	
	public void render(Graphics g)
	{
		int xMin=0;
		int yMin=0;
		int xMax=this.width-1;
		int yMax=this.height-1;	
		this.recursRender(this.leftRootNode,xMin,yMax,xMax,yMin,xMin,yMin,g);
		this.recursRender(this.rightRootNode,xMax,yMin,xMin,yMax,xMax,yMax,g);
	}
}