/*
 * Decompiled with CFR 0.152.
 */
package net.dzzd.core;

import java.awt.Image;
import java.awt.image.PixelGrabber;
import net.dzzd.access.IImageTexture;
import net.dzzd.core.Texture;
import net.dzzd.utils.Log;

public class ImageTexture
extends Texture
implements IImageTexture {
    public static final long serialVersionUID = 1L;
    protected Image image = null;

    public ImageTexture() {
    }

    public ImageTexture(Image image) {
        this();
        this.setImage(image);
    }

    public void build() {
        super.build();
    }

    public void setImage(Image image) {
        this.image = image;
        this.resizeImageToTexture();
        this.imageToTexturePixels();
        Log.log("width=" + this.width);
        Log.log("height=" + this.height);
        Log.log("maskWidth=" + this.maskWidth);
        Log.log("maskHeight=" + this.maskHeight);
        Log.log("decalWidth=" + this.decalWidth);
        Log.log("decalHeight=" + this.decalHeight);
    }

    private void resizeImageToTexture() {
        int n = this.image.getWidth(null);
        int n2 = this.image.getHeight(null);
        this.setSize(n, n2);
        if (n != this.width || n2 != this.height) {
            Image image;
            this.image = image = this.image.getScaledInstance(this.width, this.height, 4);
        }
    }

    private void imageToTexturePixels() {
        this.pixels = new int[this.width * this.height];
        PixelGrabber pixelGrabber = new PixelGrabber(this.image, 0, 0, this.width, this.height, this.pixels, 0, this.width);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        int n = this.pixels[0] & 0xFF000000;
        for (int i = 1; i < this.pixels.length; ++i) {
            if ((this.pixels[i] & 0xFF000000) == n) continue;
            this.setAlphaChannelEnabled(true);
        }
        this.image.flush();
        this.image = null;
        System.gc();
    }
}

