/*
 * Decompiled with CFR 0.152.
 */
package net.dzzd.core;

import java.io.Serializable;
import net.dzzd.access.IFace3D;
import net.dzzd.access.IMaterial;
import net.dzzd.access.IMesh3D;
import net.dzzd.access.IMesh3DCollisionGenerator;
import net.dzzd.access.IMesh3DOctree;
import net.dzzd.access.IMesh3DViewGenerator;
import net.dzzd.access.IPoint3D;
import net.dzzd.access.IScene3DObject;
import net.dzzd.access.IVertex3D;
import net.dzzd.core.Face3D;
import net.dzzd.core.Material;
import net.dzzd.core.Mesh3DOctree;
import net.dzzd.core.Scene3DObject;
import net.dzzd.core.Vertex3D;
import net.dzzd.utils.Log;

public class Mesh3D
extends Scene3DObject
implements IMesh3D {
    public static final long serialVersionUID = 1L;
    Vertex3D[] vertices3D = new Vertex3D[0];
    Face3D[] faces3D = new Face3D[0];
    transient Mesh3DOctree octree = null;
    public IMesh3DViewGenerator meshViewGenerator = null;
    public IMesh3DCollisionGenerator meshCollisionGenerator = null;
    boolean castShadowFlag = true;
    boolean recvShadowFlag = true;
    boolean octreeEnabled = true;

    public Mesh3D() {
    }

    public Mesh3D(IVertex3D[] iVertex3DArray, IFace3D[] iFace3DArray) {
        this();
        this.vertices3D = (Vertex3D[])iVertex3DArray;
        this.faces3D = (Face3D[])iFace3DArray;
        this.buildVertexId();
        this.buildFaceId();
    }

    public void build() {
        Log.log("Mesh3D.build() : " + this.nom);
        super.build();
        this.buildVertexId();
        this.buildFaceId();
        this.removeDuplicateVertices();
        this.removeInvalideFaces();
        this.buildFacesNormals();
        this.buildSphereBoxAndCenter();
        if (this.meshViewGenerator == null) {
            this.buildMesh3DOctree();
        }
    }

    public void buildVertexId() {
        for (int i = 0; i < this.vertices3D.length; ++i) {
            this.vertices3D[i].id = i;
        }
    }

    public void buildFaceId() {
        for (int i = 0; i < this.faces3D.length; ++i) {
            this.faces3D[i].id = i;
        }
    }

    public void buildSphereBoxAndCenter() {
        double d;
        this.sphereBox = 0.0;
        double d2 = Double.MAX_VALUE;
        double d3 = -1.7976931348623157E308;
        double d4 = Double.MAX_VALUE;
        double d5 = -1.7976931348623157E308;
        double d6 = Double.MAX_VALUE;
        double d7 = -1.7976931348623157E308;
        for (int i = 0; i < this.vertices3D.length; ++i) {
            Vertex3D vertex3D = this.vertices3D[i];
            if (vertex3D.x > d3) {
                d3 = vertex3D.x;
            }
            if (vertex3D.x < d2) {
                d2 = vertex3D.x;
            }
            if (vertex3D.y > d5) {
                d5 = vertex3D.y;
            }
            if (vertex3D.y < d4) {
                d4 = vertex3D.y;
            }
            if (vertex3D.z > d7) {
                d7 = vertex3D.z;
            }
            if (!(vertex3D.z < d6)) continue;
            d6 = vertex3D.z;
        }
        double d8 = (d3 + d2) * 0.5;
        double d9 = (d5 + d4) * 0.5;
        double d10 = (d7 + d6) * 0.5;
        this.center.set(d8, d9, d10);
        for (int i = 0; i < this.vertices3D.length; ++i) {
            Vertex3D vertex3D = this.vertices3D[i];
            d = this.center.dist(vertex3D);
            if (!(d > this.sphereBox)) continue;
            this.sphereBox = d;
        }
        double d11 = d3 / 2.0 - d2 / 2.0;
        d = d5 / 2.0 - d4 / 2.0;
        double d12 = d7 / 2.0 - d6 / 2.0;
        double d13 = d11 * d11 + d * d + d12 * d12;
        this.sphereBox = Math.sqrt(d13);
        for (int i = 0; i < this.faces3D.length; ++i) {
            this.faces3D[i].initSphereBox();
        }
    }

    public void removeInvalideFaces() {
        Face3D[] face3DArray;
        int n;
        int n2;
        int[] nArray = new int[this.faces3D.length];
        for (n2 = 0; n2 < nArray.length; ++n2) {
            nArray[n2] = 1;
        }
        n2 = 0;
        for (n = 0; n < this.faces3D.length; ++n) {
            face3DArray = this.faces3D[n];
            if (face3DArray.p0.equals(face3DArray.p1)) {
                nArray[n] = 0;
            } else if (face3DArray.p0.equals(face3DArray.p2)) {
                nArray[n] = 0;
            } else if (face3DArray.p1.equals(face3DArray.p2)) {
                nArray[n] = 0;
            } else {
                ++n2;
            }
            if (nArray[n] != 0) continue;
            System.out.println("*********************\n*********\nremove face :" + n);
        }
        n = 0;
        face3DArray = new Face3D[n2];
        for (int i = 0; i < this.faces3D.length; ++i) {
            if (nArray[i] != 1) continue;
            face3DArray[n++] = this.faces3D[i];
        }
        this.faces3D = face3DArray;
        this.buildFaceId();
    }

    public void removeDuplicateVertices() {
        Serializable serializable;
        int n;
        int n2;
        Vertex3D[] vertex3DArray = new Vertex3D[this.vertices3D.length];
        int[] nArray = new int[this.vertices3D.length];
        for (n2 = 0; n2 < nArray.length; ++n2) {
            nArray[n2] = -1;
        }
        n2 = 0;
        for (n = 0; n < this.vertices3D.length; ++n) {
            serializable = this.vertices3D[n];
            boolean bl = false;
            for (int i = 0; i < n2; ++i) {
                if (!vertex3DArray[i].equals((IPoint3D)((Object)serializable))) continue;
                bl = true;
                nArray[serializable.id] = i;
                break;
            }
            if (bl) continue;
            nArray[serializable.id] = n2;
            vertex3DArray[n2++] = serializable;
        }
        this.vertices3D = new Vertex3D[n2];
        for (n = 0; n < n2; ++n) {
            this.vertices3D[n] = vertex3DArray[n];
        }
        for (n = 0; n < this.faces3D.length; ++n) {
            serializable = this.faces3D[n];
            ((Face3D)serializable).p0 = this.vertices3D[nArray[((Face3D)serializable).p0.id]];
            ((Face3D)serializable).p1 = this.vertices3D[nArray[((Face3D)serializable).p1.id]];
            ((Face3D)serializable).p2 = this.vertices3D[nArray[((Face3D)serializable).p2.id]];
        }
        this.buildVertexId();
    }

    public void buildFacesNormals() {
        int n;
        int[] nArray = new int[this.vertices3D.length];
        double[] dArray = new double[this.vertices3D.length];
        double[] dArray2 = new double[this.vertices3D.length];
        double[] dArray3 = new double[this.vertices3D.length];
        for (n = 0; n < this.faces3D.length; ++n) {
            Face3D face3D = this.faces3D[n];
            face3D.object = this;
            face3D.setNormal();
        }
        for (n = 1; n < 32; ++n) {
            Serializable serializable;
            int n2;
            int n3 = 0;
            n3 = 1 << n - 1;
            for (n2 = 0; n2 < this.vertices3D.length; ++n2) {
                nArray[n2] = 0;
                serializable = this.vertices3D[n2];
                serializable.id = n2;
                dArray[n2] = 0.0;
                dArray2[n2] = 0.0;
                dArray3[n2] = 0.0;
            }
            for (n2 = 0; n2 < this.faces3D.length; ++n2) {
                serializable = this.faces3D[n2];
                if (((Face3D)serializable).smoothGroupMask != n3 && (((Face3D)serializable).smoothGroupMask & n3) == 0) continue;
                double d = ((Face3D)serializable).pa;
                double d2 = ((Face3D)serializable).pb;
                double d3 = ((Face3D)serializable).pc;
                Vertex3D vertex3D = null;
                Vertex3D vertex3D2 = null;
                Vertex3D vertex3D3 = null;
                for (int i = 0; i < 3; ++i) {
                    switch (i) {
                        case 0: {
                            vertex3D = ((Face3D)serializable).p1;
                            vertex3D2 = ((Face3D)serializable).p0;
                            vertex3D3 = ((Face3D)serializable).p2;
                            break;
                        }
                        case 1: {
                            vertex3D = ((Face3D)serializable).p2;
                            vertex3D2 = ((Face3D)serializable).p1;
                            vertex3D3 = ((Face3D)serializable).p0;
                            break;
                        }
                        case 2: {
                            vertex3D = ((Face3D)serializable).p0;
                            vertex3D2 = ((Face3D)serializable).p2;
                            vertex3D3 = ((Face3D)serializable).p1;
                        }
                    }
                    double d4 = vertex3D2.x - vertex3D.x;
                    double d5 = vertex3D2.y - vertex3D.y;
                    double d6 = vertex3D2.z - vertex3D.z;
                    double d7 = vertex3D3.x - vertex3D.x;
                    double d8 = vertex3D3.y - vertex3D.y;
                    double d9 = vertex3D3.z - vertex3D.z;
                    double d10 = d4 * d7 + d5 * d8 + d6 * d9;
                    double d11 = Math.sqrt(d4 * d4 + d5 * d5 + d6 * d6);
                    double d12 = Math.sqrt(d7 * d7 + d8 * d8 + d9 * d9);
                    int n4 = vertex3D.id;
                    if (d11 * d12 == 0.0) continue;
                    if ((d10 /= d11 * d12) > 1.0) {
                        d10 = 1.0;
                    }
                    if (d10 < -1.0) {
                        d10 = -1.0;
                    }
                    double d13 = Math.acos(d10);
                    int n5 = n4;
                    dArray[n5] = dArray[n5] + d * d13;
                    int n6 = n4;
                    dArray2[n6] = dArray2[n6] + d2 * d13;
                    int n7 = n4;
                    dArray3[n7] = dArray3[n7] + d3 * d13;
                    int n8 = n4;
                    nArray[n8] = nArray[n8] + 1;
                }
            }
            for (n2 = 0; n2 < this.vertices3D.length; ++n2) {
                double d = dArray[n2];
                double d14 = dArray2[n2];
                double d15 = dArray3[n2];
                double d16 = 1.0 / Math.sqrt(d * d + d14 * d14 + d15 * d15);
                dArray[n2] = d *= d16;
                dArray2[n2] = d14 *= d16;
                dArray3[n2] = d15 *= d16;
            }
            for (n2 = 0; n2 < this.faces3D.length; ++n2) {
                Face3D face3D = this.faces3D[n2];
                if ((face3D.smoothGroupMask & n3) == 0) continue;
                Vertex3D vertex3D = face3D.p0;
                Vertex3D vertex3D4 = face3D.p1;
                Vertex3D vertex3D5 = face3D.p2;
                int n9 = vertex3D.id;
                int n10 = vertex3D4.id;
                int n11 = vertex3D5.id;
                face3D.p0nx = (float)dArray[n9];
                face3D.p0ny = (float)dArray2[n9];
                face3D.p0nz = (float)dArray3[n9];
                face3D.p1nx = (float)dArray[n10];
                face3D.p1ny = (float)dArray2[n10];
                face3D.p1nz = (float)dArray3[n10];
                face3D.p2nx = (float)dArray[n11];
                face3D.p2ny = (float)dArray2[n11];
                face3D.p2nz = (float)dArray3[n11];
            }
        }
    }

    public void buildMesh3DOctree() {
        if (this.faces3D.length == 0 || !this.octreeEnabled || this.meshViewGenerator != null) {
            this.octree = null;
            return;
        }
        double d = Math.sqrt(this.sphereBox * this.sphereBox / 3.0) * 2.0;
        int[] nArray = new int[this.faces3D.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = -1;
        }
        long l = System.currentTimeMillis();
        this.octree = new Mesh3DOctree(this, 0, this.center.x, this.center.y, this.center.z, this.sphereBox, d, this.faces3D, nArray, null);
        l = System.currentTimeMillis();
        this.octree.generate();
        l = System.currentTimeMillis();
        this.octree.generateFaces();
        l = System.currentTimeMillis();
        int n = this.octree.initMesh3DOctreeId(0);
    }

    public void flipNormals() {
        for (int i = 0; i < this.faces3D.length; ++i) {
            this.faces3D[i].flipNormal();
        }
    }

    public void zoom(double d, double d2, double d3) {
        for (int i = 0; i < this.vertices3D.length; ++i) {
            this.vertices3D[i].sub(this.pivot);
            this.vertices3D[i].zoom(d, d2, d3);
            this.vertices3D[i].add(this.pivot);
        }
        super.zoom(d, d2, d3);
        this.buildFacesNormals();
        this.buildSphereBoxAndCenter();
        if (this.octree != null) {
            this.buildMesh3DOctree();
        }
    }

    public int getNbFace3D() {
        return this.faces3D.length;
    }

    public int getNbVertex3D() {
        return this.vertices3D.length;
    }

    public IFace3D getFace3D(int n) {
        if (n >= this.faces3D.length || n < 0) {
            return null;
        }
        return this.faces3D[n];
    }

    public IFace3D[] getFaces3D() {
        return this.faces3D;
    }

    public IVertex3D getVertex3D(int n) {
        return this.vertices3D[n];
    }

    public IVertex3D[] getVertex3D() {
        return this.vertices3D;
    }

    public double getSphereBox() {
        return this.sphereBox;
    }

    public void copy(IMesh3D iMesh3D) {
        int n;
        Mesh3D mesh3D = (Mesh3D)iMesh3D;
        this.renderMode = mesh3D.renderMode;
        Face3D[] face3DArray = new Face3D[mesh3D.faces3D.length];
        Vertex3D[] vertex3DArray = new Vertex3D[mesh3D.vertices3D.length];
        for (n = 0; n < vertex3DArray.length; ++n) {
            vertex3DArray[n] = (Vertex3D)mesh3D.vertices3D[n].getClone();
            vertex3DArray[n].id = n;
        }
        iMesh3D.buildVertexId();
        for (n = 0; n < face3DArray.length; ++n) {
            Face3D face3D = mesh3D.faces3D[n];
            Vertex3D[] vertex3DArray2 = new Vertex3D[]{vertex3DArray[face3D.p0.id], vertex3DArray[face3D.p1.id], vertex3DArray[face3D.p2.id]};
            Face3D face3D2 = new Face3D(vertex3DArray2[0], vertex3DArray2[1], vertex3DArray2[2]);
            face3D2.id = n;
            face3D2.smoothGroupMask = face3D.smoothGroupMask;
            face3D2.material = face3D.material;
            face3D2.object = this;
            face3D2.pa = face3D.pa;
            face3D2.pb = face3D.pb;
            face3D2.pc = face3D.pc;
            face3D2.pd = face3D.pd;
            face3D2.u0 = face3D.u0;
            face3D2.v0 = face3D.v0;
            face3D2.u1 = face3D.u1;
            face3D2.v1 = face3D.v1;
            face3D2.u2 = face3D.u2;
            face3D2.v2 = face3D.v2;
            face3D2.p0nx = face3D.p0nx;
            face3D2.p0ny = face3D.p0ny;
            face3D2.p0nz = face3D.p0nz;
            face3D2.p1nx = face3D.p1nx;
            face3D2.p1ny = face3D.p1ny;
            face3D2.p1nz = face3D.p1nz;
            face3D2.p2nx = face3D.p2nx;
            face3D2.p2ny = face3D.p2ny;
            face3D2.p2nz = face3D.p2nz;
            face3DArray[n] = face3D2;
        }
        this.faces3D = face3DArray;
        this.vertices3D = vertex3DArray;
        super.copy(iMesh3D);
    }

    public IScene3DObject getClone(boolean bl) {
        Mesh3D mesh3D = new Mesh3D();
        mesh3D.copy(this);
        if (bl) {
            Scene3DObject scene3DObject = this.firstChild;
            while (scene3DObject != null) {
                mesh3D.addChild(scene3DObject.getClone(bl));
                scene3DObject = scene3DObject.nextChild;
            }
        }
        return mesh3D;
    }

    public IMesh3DViewGenerator getMesh3DViewGenerator() {
        return this.meshViewGenerator;
    }

    public void setMesh3DViewGenerator(IMesh3DViewGenerator iMesh3DViewGenerator) {
        this.meshViewGenerator = iMesh3DViewGenerator;
    }

    public IMesh3DCollisionGenerator getMesh3DCollisionGenerator() {
        return this.meshCollisionGenerator;
    }

    public void setMesh3DCollisionGenerator(IMesh3DCollisionGenerator iMesh3DCollisionGenerator) {
        this.meshCollisionGenerator = iMesh3DCollisionGenerator;
    }

    public void setMaterial(IMaterial iMaterial) {
        Material material = (Material)iMaterial;
        for (int i = 0; i < this.faces3D.length; ++i) {
            this.faces3D[i].setMaterial(material);
        }
    }

    public void setCastShadow(boolean bl) {
        this.castShadowFlag = bl;
    }

    public boolean getCastShadow() {
        return this.castShadowFlag;
    }

    public void setRecvShadow(boolean bl) {
        this.recvShadowFlag = bl;
    }

    public boolean getRecvShadow() {
        return this.recvShadowFlag;
    }

    public void setOctreeEnabled(boolean bl) {
        this.octreeEnabled = bl;
    }

    public boolean getOctreeEnabled() {
        return this.octreeEnabled;
    }

    public IMesh3DOctree getMesh3DOctree() {
        return this.octree;
    }

    public void setMappingUV(float[] fArray) {
        int n = 0;
        int n2 = 0;
        while (n2 < fArray.length && n < this.faces3D.length) {
            Face3D face3D = this.faces3D[n++];
            face3D.u0 = fArray[n2++];
            face3D.v0 = fArray[n2++];
            face3D.u1 = fArray[n2++];
            face3D.v1 = fArray[n2++];
            face3D.u2 = fArray[n2++];
            face3D.v2 = fArray[n2++];
        }
    }
}

